/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.visual.component;

import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.material.Transparency;
import dev.engine_room.flywheel.api.material.WriteMask;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.vertex.MutableVertexList;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.ShadowInstance;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.QuadMesh;
import dev.engine_room.flywheel.lib.model.SingleMeshModel;
import dev.engine_room.flywheel.lib.visual.component.EntityComponent;
import dev.engine_room.flywheel.lib.visual.util.InstanceRecycler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public final class ShadowComponent
implements EntityComponent {
    private static final ResourceLocation SHADOW_TEXTURE = new ResourceLocation("textures/misc/shadow.png");
    private static final Material SHADOW_MATERIAL = SimpleMaterial.builder().texture(SHADOW_TEXTURE).mipmap(false).polygonOffset(true).transparency(Transparency.TRANSLUCENT).writeMask(WriteMask.COLOR).build();
    private static final Model SHADOW_MODEL = new SingleMeshModel(ShadowMesh.INSTANCE, SHADOW_MATERIAL);
    private final VisualizationContext context;
    private final Entity entity;
    private final Level level;
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private final InstanceRecycler<ShadowInstance> instances = new InstanceRecycler<ShadowInstance>(this::createInstance);
    private float radius = 0.0f;
    private float strength = 1.0f;

    public ShadowComponent(VisualizationContext context, Entity entity) {
        this.context = context;
        this.entity = entity;
        this.level = entity.m_9236_();
    }

    private ShadowInstance createInstance() {
        return this.context.instancerProvider().instancer(InstanceTypes.SHADOW, SHADOW_MODEL).createInstance();
    }

    public float radius() {
        return this.radius;
    }

    public float strength() {
        return this.strength;
    }

    public ShadowComponent radius(float radius) {
        this.radius = Math.min(radius, 32.0f);
        return this;
    }

    public ShadowComponent strength(float strength) {
        this.strength = strength;
        return this;
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        this.instances.resetCount();
        boolean shadowsEnabled = (Boolean)Minecraft.m_91087_().f_91066_.m_231818_().m_231551_();
        if (shadowsEnabled && this.radius > 0.0f && !this.entity.m_20145_()) {
            this.setupInstances(context);
        }
        this.instances.discardExtra();
    }

    private void setupInstances(DynamicVisual.Context context) {
        double entityX = Mth.m_14139_((double)context.partialTick(), (double)this.entity.f_19790_, (double)this.entity.m_20185_());
        double entityY = Mth.m_14139_((double)context.partialTick(), (double)this.entity.f_19791_, (double)this.entity.m_20186_());
        double entityZ = Mth.m_14139_((double)context.partialTick(), (double)this.entity.f_19792_, (double)this.entity.m_20189_());
        float castDistance = Math.min(this.strength * 2.0f, this.radius);
        int minXPos = Mth.m_14107_((double)(entityX - (double)this.radius));
        int maxXPos = Mth.m_14107_((double)(entityX + (double)this.radius));
        int minYPos = Mth.m_14107_((double)(entityY - (double)castDistance));
        int maxYPos = Mth.m_14107_((double)entityY);
        int minZPos = Mth.m_14107_((double)(entityZ - (double)this.radius));
        int maxZPos = Mth.m_14107_((double)(entityZ + (double)this.radius));
        for (int z = minZPos; z <= maxZPos; ++z) {
            for (int x = minXPos; x <= maxXPos; ++x) {
                this.pos.m_122178_(x, 0, z);
                ChunkAccess chunk = this.level.m_46865_((BlockPos)this.pos);
                for (int y = minYPos; y <= maxYPos; ++y) {
                    this.pos.m_142448_(y);
                    float strengthGivenYFalloff = this.strength - (float)(entityY - (double)this.pos.m_123342_()) * 0.5f;
                    this.setupInstance(chunk, this.pos, (float)entityX, (float)entityZ, strengthGivenYFalloff);
                }
            }
        }
    }

    private void setupInstance(ChunkAccess chunk, BlockPos.MutableBlockPos pos, float entityX, float entityZ, float strength) {
        int maxLocalRawBrightness = this.level.m_46803_((BlockPos)pos);
        if (maxLocalRawBrightness <= 3) {
            return;
        }
        float blockBrightness = LightTexture.m_234316_((DimensionType)this.level.m_6042_(), (int)maxLocalRawBrightness);
        float alpha = strength * 0.5f * blockBrightness;
        if (alpha < 0.0f) {
            return;
        }
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        pos.m_142448_(pos.m_123342_() - 1);
        VoxelShape shape = this.getShapeAt(chunk, (BlockPos)pos);
        if (shape == null) {
            return;
        }
        Vec3i renderOrigin = this.context.renderOrigin();
        int x = pos.m_123341_() - renderOrigin.m_123341_();
        int y = pos.m_123342_() - renderOrigin.m_123342_() + 1;
        int z = pos.m_123343_() - renderOrigin.m_123343_();
        double minX = (double)x + shape.m_83288_(Direction.Axis.X);
        double minY = (double)y + shape.m_83288_(Direction.Axis.Y);
        double minZ = (double)z + shape.m_83288_(Direction.Axis.Z);
        double maxX = (double)x + shape.m_83297_(Direction.Axis.X);
        double maxZ = (double)z + shape.m_83297_(Direction.Axis.Z);
        ShadowInstance instance = this.instances.get();
        instance.x = (float)minX;
        instance.y = (float)minY;
        instance.z = (float)minZ;
        instance.entityX = entityX - (float)renderOrigin.m_123341_();
        instance.entityZ = entityZ - (float)renderOrigin.m_123343_();
        instance.sizeX = (float)(maxX - minX);
        instance.sizeZ = (float)(maxZ - minZ);
        instance.alpha = alpha;
        instance.radius = this.radius;
        instance.setChanged();
    }

    @Nullable
    private VoxelShape getShapeAt(ChunkAccess chunk, BlockPos pos) {
        BlockState state = chunk.m_8055_(pos);
        if (state.m_60799_() == RenderShape.INVISIBLE) {
            return null;
        }
        if (!state.m_60838_((BlockGetter)chunk, pos)) {
            return null;
        }
        VoxelShape shape = state.m_60808_((BlockGetter)chunk, pos);
        if (shape.m_83281_()) {
            return null;
        }
        return shape;
    }

    @Override
    public void delete() {
        this.instances.delete();
    }

    private static class ShadowMesh
    implements QuadMesh {
        private static final Vector4fc BOUNDING_SPHERE = new Vector4f(0.5f, 0.0f, 0.5f, (float)(Math.sqrt(2.0) * 0.5));
        private static final ShadowMesh INSTANCE = new ShadowMesh();

        private ShadowMesh() {
        }

        @Override
        public int vertexCount() {
            return 4;
        }

        @Override
        public void write(MutableVertexList vertexList) {
            ShadowMesh.writeVertex(vertexList, 0, 0.0f, 0.0f);
            ShadowMesh.writeVertex(vertexList, 1, 0.0f, 1.0f);
            ShadowMesh.writeVertex(vertexList, 2, 1.0f, 1.0f);
            ShadowMesh.writeVertex(vertexList, 3, 1.0f, 0.0f);
        }

        private static void writeVertex(MutableVertexList vertexList, int i, float x, float z) {
            vertexList.x(i, x);
            vertexList.y(i, 0.0f);
            vertexList.z(i, z);
            vertexList.r(i, 1.0f);
            vertexList.g(i, 1.0f);
            vertexList.b(i, 1.0f);
            vertexList.u(i, 0.0f);
            vertexList.v(i, 0.0f);
            vertexList.light(i, 0xF000F0);
            vertexList.overlay(i, OverlayTexture.f_118083_);
            vertexList.normalX(i, 0.0f);
            vertexList.normalY(i, 1.0f);
            vertexList.normalZ(i, 0.0f);
        }

        @Override
        public Vector4fc boundingSphere() {
            return BOUNDING_SPHERE;
        }
    }
}

