/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.visual.component;

import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.LineModelBuilder;
import dev.engine_room.flywheel.lib.visual.component.EntityComponent;
import dev.engine_room.flywheel.lib.visual.util.SmartRecycler;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public final class HitboxComponent
implements EntityComponent {
    public static final Model BOX_MODEL = new LineModelBuilder(12).line(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).line(0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f).line(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f).line(0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f).line(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f).line(0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f).line(1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f).line(1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f).line(1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f).line(1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f).line(1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f).line(1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f).build();
    public static final Model LINE_MODEL = new LineModelBuilder(1).line(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f).build();
    private final VisualizationContext context;
    private final Entity entity;
    private final SmartRecycler<Model, TransformedInstance> recycler;
    private boolean showEyeBox;

    public HitboxComponent(VisualizationContext context, Entity entity) {
        this.context = context;
        this.entity = entity;
        this.showEyeBox = entity instanceof LivingEntity;
        this.recycler = new SmartRecycler<Model, TransformedInstance>(this::createInstance);
    }

    private TransformedInstance createInstance(Model model) {
        TransformedInstance instance = this.context.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model).createInstance();
        instance.light(240);
        instance.setChanged();
        return instance;
    }

    public boolean doesShowEyeBox() {
        return this.showEyeBox;
    }

    public HitboxComponent showEyeBox(boolean showEyeBox) {
        this.showEyeBox = showEyeBox;
        return this;
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        this.recycler.resetCount();
        boolean shouldRenderHitBoxes = Minecraft.m_91087_().m_91290_().m_114377_();
        if (shouldRenderHitBoxes && !this.entity.m_20145_() && !Minecraft.m_91087_().m_91299_()) {
            float partialTick = context.partialTick();
            double entityX = Mth.m_14139_((double)partialTick, (double)this.entity.f_19790_, (double)this.entity.m_20185_());
            double entityY = Mth.m_14139_((double)partialTick, (double)this.entity.f_19791_, (double)this.entity.m_20186_());
            double entityZ = Mth.m_14139_((double)partialTick, (double)this.entity.f_19792_, (double)this.entity.m_20189_());
            AABB bb = this.entity.m_20191_();
            double boxX = entityX + bb.f_82288_ - this.entity.m_20185_();
            double boxY = entityY + bb.f_82289_ - this.entity.m_20186_();
            double boxZ = entityZ + bb.f_82290_ - this.entity.m_20189_();
            float widthX = (float)(bb.f_82291_ - bb.f_82288_);
            float widthY = (float)(bb.f_82292_ - bb.f_82289_);
            float widthZ = (float)(bb.f_82293_ - bb.f_82290_);
            ((TransformedInstance)this.recycler.get(BOX_MODEL).setIdentityTransform().translate(boxX, boxY, boxZ)).scale(widthX, widthY, widthZ).setChanged();
            if (this.showEyeBox) {
                ((TransformedInstance)this.recycler.get(BOX_MODEL).setIdentityTransform().translate(boxX, entityY + (double)this.entity.m_20192_() - 0.01, boxZ)).scale(widthX, 0.02f, widthZ).color(255, 0, 0).setChanged();
            }
            Vec3 viewVector = this.entity.m_20252_(partialTick);
            ((TransformedInstance)this.recycler.get(LINE_MODEL).setIdentityTransform().translate(entityX, entityY + (double)this.entity.m_20192_(), entityZ)).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, 1.0f, 0.0f, (float)viewVector.f_82479_, (float)viewVector.f_82480_, (float)viewVector.f_82481_)).color(0, 0, 255).setChanged();
        }
        this.recycler.discardExtra();
    }

    @Override
    public void delete() {
        this.recycler.delete();
    }
}

