/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.visual;

import dev.engine_room.flywheel.api.visual.EntityVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.visual.AbstractVisual;
import dev.engine_room.flywheel.lib.visual.EntityVisibilityTester;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.FrustumIntersection;
import org.joml.Vector3f;

public abstract class AbstractEntityVisual<T extends Entity>
extends AbstractVisual
implements EntityVisual<T> {
    protected final T entity;
    protected final EntityVisibilityTester visibilityTester;

    public AbstractEntityVisual(VisualizationContext ctx, T entity, float partialTick) {
        super(ctx, entity.m_9236_(), partialTick);
        this.entity = entity;
        this.visibilityTester = new EntityVisibilityTester((Entity)entity, ctx.renderOrigin(), 1.5f);
    }

    public double distanceSquared(double x, double y, double z) {
        return this.entity.m_20275_(x, y, z);
    }

    public Vector3f getVisualPosition() {
        Vec3 pos = this.entity.m_20182_();
        Vec3i renderOrigin = this.renderOrigin();
        return new Vector3f((float)(pos.f_82479_ - (double)renderOrigin.m_123341_()), (float)(pos.f_82480_ - (double)renderOrigin.m_123342_()), (float)(pos.f_82481_ - (double)renderOrigin.m_123343_()));
    }

    public Vector3f getVisualPosition(float partialTick) {
        Vec3 pos = this.entity.m_20182_();
        Vec3i renderOrigin = this.renderOrigin();
        return new Vector3f((float)(Mth.m_14139_((double)partialTick, (double)((Entity)this.entity).f_19790_, (double)pos.f_82479_) - (double)renderOrigin.m_123341_()), (float)(Mth.m_14139_((double)partialTick, (double)((Entity)this.entity).f_19791_, (double)pos.f_82480_) - (double)renderOrigin.m_123342_()), (float)(Mth.m_14139_((double)partialTick, (double)((Entity)this.entity).f_19792_, (double)pos.f_82481_) - (double)renderOrigin.m_123343_()));
    }

    public boolean isVisible(FrustumIntersection frustum) {
        return ((Entity)this.entity).f_19811_ || this.visibilityTester.check(frustum);
    }

    protected int computePackedLight(float partialTick) {
        BlockPos pos = BlockPos.m_274446_((Position)this.entity.m_7371_(partialTick));
        int blockLight = this.entity.m_6060_() ? 15 : this.level.m_45517_(LightLayer.BLOCK, pos);
        int skyLight = this.level.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)blockLight, (int)skyLight);
    }

    protected void relight(float partialTick, FlatLit ... instances) {
        FlatLit.relight(this.computePackedLight(partialTick), instances);
    }
}

