/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.transform;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public final class PoseTransformStack
implements TransformStack<PoseTransformStack> {
    private final PoseStack stack;

    @ApiStatus.Internal
    public PoseTransformStack(PoseStack stack) {
        this.stack = stack;
    }

    @Override
    public PoseTransformStack pushPose() {
        this.stack.m_85836_();
        return this;
    }

    @Override
    public PoseTransformStack popPose() {
        this.stack.m_85849_();
        return this;
    }

    @Override
    public PoseTransformStack mulPose(Matrix4fc pose) {
        this.stack.m_85850_().m_252922_().mul(pose);
        return this;
    }

    @Override
    public PoseTransformStack mulNormal(Matrix3fc normal) {
        this.stack.m_85850_().m_252943_().mul(normal);
        return this;
    }

    @Override
    public PoseTransformStack rotateAround(Quaternionfc quaternion, float x, float y, float z) {
        PoseStack.Pose pose = this.stack.m_85850_();
        pose.m_252922_().rotateAround(quaternion, x, y, z);
        pose.m_252943_().rotate(quaternion);
        return this;
    }

    @Override
    public PoseTransformStack translate(float x, float y, float z) {
        this.stack.m_252880_(x, y, z);
        return this;
    }

    @Override
    public PoseTransformStack rotate(Quaternionfc quaternion) {
        PoseStack.Pose pose = this.stack.m_85850_();
        pose.m_252922_().rotate(quaternion);
        pose.m_252943_().rotate(quaternion);
        return this;
    }

    @Override
    public PoseTransformStack scale(float factorX, float factorY, float factorZ) {
        this.stack.m_85841_(factorX, factorY, factorZ);
        return this;
    }

    public PoseStack unwrap() {
        return this.stack;
    }
}

