/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.BufferBuilder;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import dev.engine_room.flywheel.lib.model.SimpleQuadMesh;
import dev.engine_room.flywheel.lib.vertex.NoOverlayVertexView;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

final class MeshHelper {
    private MeshHelper() {
    }

    public static SimpleQuadMesh blockVerticesToMesh(BufferBuilder.RenderedBuffer buffer, @Nullable String meshDescriptor) {
        BufferBuilder.DrawState drawState = buffer.m_231198_();
        int vertexCount = drawState.f_85734_();
        long srcStride = drawState.f_85733_().m_86020_();
        NoOverlayVertexView vertexView = new NoOverlayVertexView();
        long dstStride = vertexView.stride();
        ByteBuffer src = buffer.m_231196_();
        MemoryBlock dst = MemoryBlock.mallocTracked((long)vertexCount * dstStride);
        long srcPtr = MemoryUtil.memAddress((ByteBuffer)src);
        long dstPtr = dst.ptr();
        long bytesToCopy = Math.min(dstStride, 31L);
        for (int i = 0; i < vertexCount; ++i) {
            MemoryUtil.memCopy((long)(srcPtr + srcStride * (long)i), (long)(dstPtr + dstStride * (long)i), (long)bytesToCopy);
        }
        vertexView.ptr(dstPtr);
        vertexView.vertexCount(vertexCount);
        vertexView.nativeMemoryOwner(dst);
        return new SimpleQuadMesh(vertexView, meshDescriptor);
    }
}

