/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.BufferBuilder;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.lib.model.SimpleModel;
import dev.engine_room.flywheel.lib.model.baked.BlockMaterialFunction;
import dev.engine_room.flywheel.lib.model.baked.BufferBuilderStack;
import dev.engine_room.flywheel.lib.model.baked.MeshEmitter;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

class MeshEmitterManager<T extends MeshEmitter> {
    private static final RenderType[] CHUNK_LAYERS = (RenderType[])RenderType.m_110506_().toArray(RenderType[]::new);
    private final Reference2ReferenceMap<RenderType, T> emitterMap = new Reference2ReferenceArrayMap();
    private final BufferBuilderStack bufferBuilderStack = new BufferBuilderStack();
    private @UnknownNullability BlockMaterialFunction blockMaterialFunction;

    MeshEmitterManager(BiFunction<BufferBuilderStack, RenderType, T> meshEmitterFactory) {
        for (RenderType renderType : CHUNK_LAYERS) {
            MeshEmitter emitter = (MeshEmitter)meshEmitterFactory.apply(this.bufferBuilderStack, renderType);
            this.emitterMap.put((Object)renderType, (Object)emitter);
        }
    }

    public T getEmitter(RenderType renderType) {
        return (T)((MeshEmitter)this.emitterMap.get((Object)renderType));
    }

    public void prepare(BlockMaterialFunction blockMaterialFunction) {
        this.blockMaterialFunction = blockMaterialFunction;
        this.bufferBuilderStack.reset();
        for (MeshEmitter emitter : this.emitterMap.values()) {
            emitter.prepare(blockMaterialFunction);
        }
    }

    public void prepareForBlock() {
        for (MeshEmitter emitter : this.emitterMap.values()) {
            emitter.prepareForBlock();
        }
    }

    public SimpleModel end() {
        this.blockMaterialFunction = null;
        this.bufferBuilderStack.reset();
        ImmutableList.Builder meshes = ImmutableList.builder();
        for (MeshEmitter emitter : this.emitterMap.values()) {
            emitter.end((ImmutableList.Builder<Model.ConfiguredMesh>)meshes);
        }
        return new SimpleModel((List<Model.ConfiguredMesh>)meshes.build());
    }

    @Nullable
    public BufferBuilder getBuffer(RenderType renderType, boolean shade, boolean ao) {
        Material key = this.blockMaterialFunction.apply(renderType, shade, ao);
        if (key != null) {
            return ((MeshEmitter)this.emitterMap.get((Object)renderType)).getBuffer(key);
        }
        return null;
    }
}

