/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.lib.model.SimpleQuadMesh;
import dev.engine_room.flywheel.lib.model.baked.BlockMaterialFunction;
import dev.engine_room.flywheel.lib.model.baked.BufferBuilderStack;
import dev.engine_room.flywheel.lib.model.baked.MeshHelper;
import java.util.Arrays;
import org.jetbrains.annotations.UnknownNullability;

class MeshEmitter {
    private static final int INITIAL_CAPACITY = 1;
    private final BufferBuilderStack bufferBuilderStack;
    private Material @UnknownNullability [] materials = new Material[1];
    private BufferBuilder @UnknownNullability [] bufferBuilders = new BufferBuilder[1];
    private int numBufferBuildersPopulated = 0;
    @UnknownNullability BlockMaterialFunction blockMaterialFunction;
    private int currentIndex = 0;

    MeshEmitter(BufferBuilderStack bufferBuilderStack) {
        this.bufferBuilderStack = bufferBuilderStack;
    }

    public void prepare(BlockMaterialFunction blockMaterialFunction) {
        this.blockMaterialFunction = blockMaterialFunction;
    }

    public void prepareForBlock() {
        this.currentIndex = 0;
    }

    public void end(ImmutableList.Builder<Model.ConfiguredMesh> out) {
        for (int index = 0; index < this.numBufferBuildersPopulated; ++index) {
            BufferBuilder.RenderedBuffer renderedBuffer = this.bufferBuilders[index].m_231168_();
            if (renderedBuffer == null) continue;
            Material material = this.materials[index];
            SimpleQuadMesh mesh = MeshHelper.blockVerticesToMesh(renderedBuffer, "source=ModelBuilder,material=" + material);
            out.add((Object)new Model.ConfiguredMesh(material, mesh));
            renderedBuffer.m_231200_();
        }
        Arrays.fill(this.bufferBuilders, 0, this.numBufferBuildersPopulated, null);
        Arrays.fill(this.materials, 0, this.numBufferBuildersPopulated, null);
        this.currentIndex = 0;
        this.numBufferBuildersPopulated = 0;
        this.blockMaterialFunction = null;
    }

    public BufferBuilder getBuffer(Material material) {
        while (this.currentIndex < this.numBufferBuildersPopulated) {
            if (material.equals(this.materials[this.currentIndex])) {
                return this.bufferBuilders[this.currentIndex];
            }
            ++this.currentIndex;
        }
        if (this.currentIndex >= this.materials.length) {
            this.resize(this.materials.length * 2);
        }
        BufferBuilder bufferBuilder = this.bufferBuilderStack.getOrCreateBufferBuilder();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        this.materials[this.currentIndex] = material;
        this.bufferBuilders[this.currentIndex] = bufferBuilder;
        ++this.numBufferBuildersPopulated;
        return bufferBuilder;
    }

    private void resize(int capacity) {
        BufferBuilder[] newBufferBuilders = new BufferBuilder[capacity];
        Material[] newMaterials = new Material[capacity];
        System.arraycopy(this.bufferBuilders, 0, newBufferBuilders, 0, this.numBufferBuildersPopulated);
        System.arraycopy(this.materials, 0, newMaterials, 0, this.numBufferBuildersPopulated);
        this.bufferBuilders = newBufferBuilders;
        this.materials = newMaterials;
    }
}

