/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.lib.model.baked.BufferBuilderStack;
import dev.engine_room.flywheel.lib.model.baked.MeshEmitter;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ForgeMeshEmitter
extends MeshEmitter
implements VertexConsumer {
    private final RenderType renderType;
    private boolean defaultAo;

    ForgeMeshEmitter(BufferBuilderStack bufferBuilderStack, RenderType renderType) {
        super(bufferBuilderStack);
        this.renderType = renderType;
    }

    public void prepareForModelLayer(boolean defaultAo) {
        this.defaultAo = defaultAo;
    }

    @Nullable
    private BufferBuilder getBuffer(boolean shade, boolean ao) {
        Material key = this.blockMaterialFunction.apply(this.renderType, shade, ao);
        if (key != null) {
            return this.getBuffer(key);
        }
        return null;
    }

    @Nullable
    private BufferBuilder getBuffer(BakedQuad quad) {
        boolean shade = quad.m_111307_();
        boolean ao = quad.hasAmbientOcclusion() && this.defaultAo;
        return this.getBuffer(shade, ao);
    }

    public void m_85987_(PoseStack.Pose pose, BakedQuad quad, float red, float green, float blue, int light, int overlay) {
        BufferBuilder bufferBuilder = this.getBuffer(quad);
        if (bufferBuilder != null) {
            bufferBuilder.m_85987_(pose, quad, red, green, blue, light, overlay);
        }
    }

    public void putBulkData(PoseStack.Pose pose, BakedQuad quad, float red, float green, float blue, float alpha, int light, int overlay, boolean readExistingColor) {
        BufferBuilder bufferBuilder = this.getBuffer(quad);
        if (bufferBuilder != null) {
            bufferBuilder.putBulkData(pose, quad, red, green, blue, alpha, light, overlay, readExistingColor);
        }
    }

    public void m_85995_(PoseStack.Pose pose, BakedQuad quad, float[] brightnesses, float red, float green, float blue, int[] lights, int overlay, boolean readExistingColor) {
        BufferBuilder bufferBuilder = this.getBuffer(quad);
        if (bufferBuilder != null) {
            bufferBuilder.m_85995_(pose, quad, brightnesses, red, green, blue, lights, overlay, readExistingColor);
        }
    }

    public void putBulkData(PoseStack.Pose pose, BakedQuad quad, float[] brightnesses, float red, float green, float blue, float alpha, int[] lights, int overlay, boolean readExistingColor) {
        BufferBuilder bufferBuilder = this.getBuffer(quad);
        if (bufferBuilder != null) {
            bufferBuilder.putBulkData(pose, quad, brightnesses, red, green, blue, alpha, lights, overlay, readExistingColor);
        }
    }

    public VertexConsumer m_5483_(double x, double y, double z) {
        throw new UnsupportedOperationException("ForgeMeshEmitter only supports putBulkData!");
    }

    public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
        throw new UnsupportedOperationException("ForgeMeshEmitter only supports putBulkData!");
    }

    public VertexConsumer m_7421_(float u, float v) {
        throw new UnsupportedOperationException("ForgeMeshEmitter only supports putBulkData!");
    }

    public VertexConsumer m_7122_(int u, int v) {
        throw new UnsupportedOperationException("ForgeMeshEmitter only supports putBulkData!");
    }

    public VertexConsumer m_7120_(int u, int v) {
        throw new UnsupportedOperationException("ForgeMeshEmitter only supports putBulkData!");
    }

    public VertexConsumer m_5601_(float x, float y, float z) {
        throw new UnsupportedOperationException("ForgeMeshEmitter only supports putBulkData!");
    }

    public void m_5752_() {
        throw new UnsupportedOperationException("ForgeMeshEmitter only supports putBulkData!");
    }

    public void m_7404_(int red, int green, int blue, int alpha) {
        throw new UnsupportedOperationException("ForgeMeshEmitter only supports putBulkData!");
    }

    public void m_141991_() {
        throw new UnsupportedOperationException("ForgeMeshEmitter only supports putBulkData!");
    }
}

