/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.engine_room.flywheel.lib.model.SimpleModel;
import dev.engine_room.flywheel.lib.model.baked.BlockMaterialFunction;
import dev.engine_room.flywheel.lib.model.baked.ForgeMeshEmitter;
import dev.engine_room.flywheel.lib.model.baked.MeshEmitterManager;
import dev.engine_room.flywheel.lib.model.baked.TransformingVertexConsumer;
import java.util.Iterator;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

final class BakedModelBufferer {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    private BakedModelBufferer() {
    }

    public static SimpleModel bufferModel(BakedModel model, BlockPos pos, BlockAndTintGetter level, BlockState state, @Nullable PoseStack poseStack, ModelData modelData, BlockMaterialFunction blockMaterialFunction) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        RandomSource random = objects.random;
        MeshEmitterManager<ForgeMeshEmitter> emitters = objects.emitters;
        emitters.prepare(blockMaterialFunction);
        ModelBlockRenderer blockRenderer = Minecraft.m_91087_().m_91289_().m_110937_();
        long seed = state.m_60726_(pos);
        modelData = model.getModelData(level, pos, state, modelData);
        random.m_188584_(seed);
        ChunkRenderTypeSet renderTypes = model.getRenderTypes(state, random, modelData);
        boolean defaultAo = Minecraft.m_91086_() && state.getLightEmission((BlockGetter)level, pos) == 0;
        for (RenderType renderType : renderTypes) {
            boolean defaultAoLayer = defaultAo && model.useAmbientOcclusion(state, renderType);
            ForgeMeshEmitter emitter = emitters.getEmitter(renderType);
            emitter.prepareForModelLayer(defaultAoLayer);
            poseStack.m_85836_();
            blockRenderer.tesselateBlock(level, model, state, pos, poseStack, (VertexConsumer)emitter, false, random, seed, OverlayTexture.f_118083_, modelData, renderType);
            poseStack.m_85849_();
        }
        return emitters.end();
    }

    public static SimpleModel bufferBlocks(Iterator<BlockPos> posIterator, BlockAndTintGetter level, @Nullable PoseStack poseStack, Function<BlockPos, ModelData> modelDataLookup, boolean renderFluids, BlockMaterialFunction blockMaterialFunction) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        RandomSource random = objects.random;
        MeshEmitterManager<ForgeMeshEmitter> emitters = objects.emitters;
        TransformingVertexConsumer transformingWrapper = objects.transformingWrapper;
        emitters.prepare(blockMaterialFunction);
        BlockRenderDispatcher renderDispatcher = Minecraft.m_91087_().m_91289_();
        ModelBlockRenderer blockRenderer = renderDispatcher.m_110937_();
        ModelBlockRenderer.m_111000_();
        boolean useAo = Minecraft.m_91086_();
        while (posIterator.hasNext()) {
            RenderType renderType;
            BufferBuilder bufferBuilder;
            FluidState fluidState;
            BlockPos pos = posIterator.next();
            BlockState state = level.m_8055_(pos);
            emitters.prepareForBlock();
            if (renderFluids && !(fluidState = state.m_60819_()).m_76178_() && (bufferBuilder = emitters.getBuffer(renderType = ItemBlockRenderTypes.m_109287_((FluidState)fluidState), true, false)) != null) {
                transformingWrapper.prepare((VertexConsumer)bufferBuilder, poseStack);
                poseStack.m_85836_();
                poseStack.m_252880_((float)(pos.m_123341_() - (pos.m_123341_() & 0xF)), (float)(pos.m_123342_() - (pos.m_123342_() & 0xF)), (float)(pos.m_123343_() - (pos.m_123343_() & 0xF)));
                renderDispatcher.m_234363_(pos, level, (VertexConsumer)transformingWrapper, state, fluidState);
                poseStack.m_85849_();
            }
            if (state.m_60799_() != RenderShape.MODEL) continue;
            long seed = state.m_60726_(pos);
            BakedModel model = renderDispatcher.m_110910_(state);
            ModelData modelData = modelDataLookup.apply(pos);
            modelData = model.getModelData(level, pos, state, modelData);
            random.m_188584_(seed);
            ChunkRenderTypeSet renderTypes = model.getRenderTypes(state, random, modelData);
            boolean defaultAo = useAo && state.getLightEmission((BlockGetter)level, pos) == 0;
            for (RenderType renderType2 : renderTypes) {
                boolean defaultAoLayer = defaultAo && model.useAmbientOcclusion(state, renderType2);
                ForgeMeshEmitter emitter = emitters.getEmitter(renderType2);
                emitter.prepareForModelLayer(defaultAoLayer);
                poseStack.m_85836_();
                poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                blockRenderer.tesselateBlock(level, model, state, pos, poseStack, (VertexConsumer)emitter, true, random, seed, OverlayTexture.f_118083_, modelData, renderType2);
                poseStack.m_85849_();
            }
        }
        ModelBlockRenderer.m_111077_();
        transformingWrapper.clear();
        return emitters.end();
    }

    private static class ThreadLocalObjects {
        public final PoseStack identityPoseStack = new PoseStack();
        public final RandomSource random = RandomSource.m_216343_();
        public final MeshEmitterManager<ForgeMeshEmitter> emitters = new MeshEmitterManager<ForgeMeshEmitter>(ForgeMeshEmitter::new);
        public final TransformingVertexConsumer transformingWrapper = new TransformingVertexConsumer();

        private ThreadLocalObjects() {
        }
    }
}

