/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl;

import dev.engine_room.flywheel.api.backend.Backend;
import dev.engine_room.flywheel.api.backend.BackendManager;
import dev.engine_room.flywheel.backend.BackendConfig;
import dev.engine_room.flywheel.backend.compile.LightSmoothness;
import dev.engine_room.flywheel.impl.FlwConfig;
import dev.engine_room.flywheel.impl.FlwImpl;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ForgeFlwConfig
implements FlwConfig {
    public static final ForgeFlwConfig INSTANCE = new ForgeFlwConfig();
    public final ClientConfig client;
    private final ForgeConfigSpec clientSpec;

    private ForgeFlwConfig() {
        Pair clientPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        this.client = (ClientConfig)clientPair.getLeft();
        this.clientSpec = (ForgeConfigSpec)clientPair.getRight();
    }

    @Override
    public Backend backend() {
        Backend backend = ForgeFlwConfig.parseBackend((String)this.client.backend.get());
        if (backend == null) {
            this.client.backend.set((Object)"DEFAULT");
            backend = BackendManager.defaultBackend();
        }
        return backend;
    }

    @Nullable
    private static Backend parseBackend(String value) {
        ResourceLocation backendId;
        if (value.equals("DEFAULT")) {
            return BackendManager.defaultBackend();
        }
        try {
            backendId = new ResourceLocation(value);
        }
        catch (ResourceLocationException e) {
            FlwImpl.CONFIG_LOGGER.warn("'backend' value '{}' is not a valid resource location", (Object)value);
            return null;
        }
        Backend backend = Backend.REGISTRY.get(backendId);
        if (backend == null) {
            FlwImpl.CONFIG_LOGGER.warn("Backend with ID '{}' is not registered", (Object)backendId);
            return null;
        }
        return backend;
    }

    @Override
    public boolean limitUpdates() {
        return (Boolean)this.client.limitUpdates.get();
    }

    @Override
    public int workerThreads() {
        return (Integer)this.client.workerThreads.get();
    }

    @Override
    public BackendConfig backendConfig() {
        return this.client.backendConfig;
    }

    public void registerSpecs(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.clientSpec);
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.ConfigValue<String> backend;
        public final ForgeConfigSpec.BooleanValue limitUpdates;
        public final ForgeConfigSpec.IntValue workerThreads;
        public final ForgeBackendConfig backendConfig;

        private ClientConfig(ForgeConfigSpec.Builder builder) {
            this.backend = builder.comment("Select the backend to use. Set to \"DEFAULT\" to let Flywheel decide.").define("backend", (Object)"DEFAULT");
            this.limitUpdates = builder.comment("Enable or disable instance update limiting with distance.").define("limitUpdates", true);
            this.workerThreads = builder.comment("The number of worker threads to use. Set to -1 to let Flywheel decide. Set to 0 to disable parallelism. Requires a game restart to take effect.").defineInRange("workerThreads", -1, -1, Runtime.getRuntime().availableProcessors());
            builder.comment("Config options for Flywheel's built-in backends.").push("flw_backends");
            this.backendConfig = new ForgeBackendConfig(builder);
        }
    }

    public static class ForgeBackendConfig
    implements BackendConfig {
        public final ForgeConfigSpec.EnumValue<LightSmoothness> lightSmoothness;

        public ForgeBackendConfig(ForgeConfigSpec.Builder builder) {
            this.lightSmoothness = builder.comment("How smooth Flywheel's shader-based lighting should be. May have a large performance impact.").defineEnum("lightSmoothness", (Enum)LightSmoothness.SMOOTH);
        }

        @Override
        public LightSmoothness lightSmoothness() {
            return (LightSmoothness)((Object)this.lightSmoothness.get());
        }
    }
}

