/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl;

import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.backend.engine.AbstractInstancer;
import dev.engine_room.flywheel.backend.engine.DrawManager;
import dev.engine_room.flywheel.backend.engine.EngineImpl;
import dev.engine_room.flywheel.backend.engine.InstancerKey;
import dev.engine_room.flywheel.backend.engine.MeshPool;
import dev.engine_room.flywheel.backend.gl.GlCompat;
import dev.engine_room.flywheel.impl.BackendManagerImpl;
import dev.engine_room.flywheel.impl.FlwConfig;
import dev.engine_room.flywheel.impl.FlwImplXplat;
import dev.engine_room.flywheel.impl.visualization.VisualizationManagerImpl;
import dev.engine_room.flywheel.lib.memory.FlwMemoryTracker;
import dev.engine_room.flywheel.lib.util.StringUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public final class FlwDebugInfo {
    private FlwDebugInfo() {
    }

    public static StringBuilder appendLine(StringBuilder dst, String str) {
        dst.append("\n- ");
        dst.append(str);
        return dst;
    }

    public static void appendHeader(StringBuilder dst, String str) {
        dst.append("\n## ");
        dst.append(str);
    }

    public static void appendHeader2(StringBuilder dst, String str) {
        dst.append("\n### ");
        dst.append(str);
    }

    public static Component getDebugCommandInfo() {
        StringBuilder out = new StringBuilder("# `/flywheel debug info`");
        VisualizationManagerImpl manager = VisualizationManagerImpl.get((LevelAccessor)Minecraft.m_91087_().f_91073_);
        FlwDebugInfo.addImplDebugInfo(out);
        FlwDebugInfo.addSystemDebugInfo(out);
        FlwDebugInfo.addOpenGLDebugInfo(out);
        FlwDebugInfo.addBackendDebugInfo(manager, out);
        FlwDebugInfo.addVisualizationManagerDebugInfo(manager, out);
        String debugInfoString = out.toString();
        return Component.m_237113_((String)debugInfoString).m_7220_((Component)Component.m_237113_((String)"\n\nClick to copy debug info to clipboard").m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, debugInfoString)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)debugInfoString))))).m_7220_((Component)Component.m_237113_((String)"\n\nClick to open an issue on GitHub").m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.BLUE).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Engine-Room/Flywheel/issues")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Opens URL:\nhttps://github.com/Engine-Room/Flywheel/issues")))));
    }

    private static void addBackendDebugInfo(@Nullable VisualizationManagerImpl manager, StringBuilder out) {
        FlwDebugInfo.appendHeader(out, "Backend");
        if (manager == null) {
            FlwDebugInfo.appendLine(out, "No visualization manager found");
            return;
        }
        EngineImpl engineImpl = manager.getEngineImpl();
        if (engineImpl == null) {
            FlwDebugInfo.appendLine(out, "Third party backend in use");
            return;
        }
        FlwDebugInfo.appendLine(out, "Environments: ").append(engineImpl.environmentStorage().arena.occupancy()).append(" / ").append(engineImpl.environmentStorage().arena.capacity());
        FlwDebugInfo.appendLine(out, "Light Sections: ").append(engineImpl.lightStorage().arena.occupancy()).append(" / ").append(engineImpl.lightStorage().arena.capacity());
        IntArrayList lut = engineImpl.lightStorage().createLut();
        FlwDebugInfo.appendLine(out, "Light LUT Size: ").append(lut.size() * 4).append(" bytes");
        DrawManager<? extends AbstractInstancer<?>> drawManager = engineImpl.drawManager();
        FlwDebugInfo.addMeshDebugInfo(out, drawManager);
        FlwDebugInfo.addInstancerDebugInfo(out, drawManager);
    }

    private static void addInstancerDebugInfo(StringBuilder out, DrawManager<? extends AbstractInstancer<?>> drawManager) {
        FlwDebugInfo.appendHeader2(out, "Instancers");
        Map<InstancerKey<?>, AbstractInstancer<?>> instancers = drawManager.instancers();
        FlwDebugInfo.appendLine(out, "Count: ").append(instancers.size());
        IntArrayList meshCountsToSort = new IntArrayList();
        for (InstancerKey<?> instancerKey : instancers.keySet()) {
            meshCountsToSort.add(instancerKey.model().meshes().size());
        }
        FlwDebugInfo.appendPercentiles(out, "Mesh Count Percentiles", (IntList)meshCountsToSort);
        int totalInstanceCount = 0;
        IntArrayList instanceCountsToSort = new IntArrayList();
        for (AbstractInstancer<?> instancer : instancers.values()) {
            int instanceCount = instancer.instanceCount();
            totalInstanceCount += instanceCount;
            instanceCountsToSort.add(instanceCount);
        }
        FlwDebugInfo.appendLine(out, "Total Instance Count: ").append(totalInstanceCount);
        FlwDebugInfo.appendPercentiles(out, "Instance Count Percentiles", (IntList)instanceCountsToSort);
    }

    private static void addMeshDebugInfo(StringBuilder out, DrawManager<? extends AbstractInstancer<?>> drawManager) {
        List<MeshPool.PooledMesh> meshPool = drawManager.meshPool().pooledMeshes();
        FlwDebugInfo.appendHeader2(out, "Meshes");
        int numMeshes = meshPool.size();
        FlwDebugInfo.appendLine(out, "Count: ").append(numMeshes);
        int totalVertices = 0;
        IntArrayList vertexCountsToSort = new IntArrayList();
        for (MeshPool.PooledMesh pooledMesh : meshPool) {
            int vertexCount = pooledMesh.vertexCount();
            vertexCountsToSort.add(vertexCount);
            totalVertices += vertexCount;
        }
        FlwDebugInfo.appendLine(out, "Total Vertex Count: ").append(totalVertices);
        FlwDebugInfo.appendPercentiles(out, "Vertex Count Percentiles", (IntList)vertexCountsToSort);
    }

    private static void appendPercentiles(StringBuilder out, String prefix, IntList unsortedCounts) {
        int size = unsortedCounts.size();
        if (size == 0) {
            FlwDebugInfo.appendLine(out, "Empty dataset, no percentiles.");
            return;
        }
        unsortedCounts.sort(IntComparators.NATURAL_COMPARATOR);
        int p10Index = Math.min(size / 10, size - 1);
        int p50Index = Math.min(size / 2, size - 1);
        int p90Index = Math.min(size * 9 / 10, size - 1);
        FlwDebugInfo.appendLine(out, prefix).append(":\n   ").append("P10: ").append(unsortedCounts.getInt(p10Index)).append(", P50: ").append(unsortedCounts.getInt(p50Index)).append(", P90: ").append(unsortedCounts.getInt(p90Index)).append(", Max: ").append(unsortedCounts.getInt(size - 1));
    }

    private static void addVisualizationManagerDebugInfo(@Nullable VisualizationManagerImpl manager, StringBuilder out) {
        if (manager == null) {
            out.append('\n');
            FlwDebugInfo.appendHeader(out, "Visualization Manager");
            FlwDebugInfo.appendLine(out, "No visualization manager found");
            return;
        }
        FlwDebugInfo.appendHeader(out, "Client Level Visualization Manager");
        Vec3i renderOrigin = manager.renderOrigin();
        FlwDebugInfo.appendLine(out, "Origin: ").append(renderOrigin.m_123341_()).append(", ").append(renderOrigin.m_123342_()).append(", ").append(renderOrigin.m_123343_());
        FlwDebugInfo.appendLine(out, "Block Entity Visuals: ").append(manager.blockEntities().visualCount());
        FlwDebugInfo.appendLine(out, "Entity Visuals: ").append(manager.entities().visualCount());
        FlwDebugInfo.appendLine(out, "Effect Visuals: ").append(manager.effects().visualCount());
    }

    private static void addImplDebugInfo(StringBuilder out) {
        FlwDebugInfo.appendHeader(out, "Impl");
        FlwDebugInfo.appendLine(out, "Flywheel Version: ").append(FlwImplXplat.INSTANCE.getVersionStr());
        FlwDebugInfo.appendLine(out, "Backend: ").append(BackendManagerImpl.getBackendString());
        FlwDebugInfo.appendLine(out, "Update limiting: ").append(FlwConfig.INSTANCE.limitUpdates() ? "on" : "off");
    }

    private static void addSystemDebugInfo(StringBuilder out) {
        FlwDebugInfo.appendHeader(out, "System Info");
        FlwDebugInfo.appendLine(out, "Java Version: ").append(System.getProperty("java.version"));
        FlwDebugInfo.appendLine(out, "Java VM: ").append(System.getProperty("java.vm.name")).append(" (").append(System.getProperty("java.vm.version")).append(")");
        FlwDebugInfo.appendLine(out, "OS: ").append(System.getProperty("os.name")).append(" (").append(System.getProperty("os.arch")).append(")");
        FlwDebugInfo.appendLine(out, "Flw CPU Memory: ").append(FlwMemoryTracker.getCpuMemory()).append(" bytes");
        FlwDebugInfo.appendLine(out, "Flw GPU Memory: ").append(FlwMemoryTracker.getGpuMemory()).append(" bytes");
    }

    private static void addOpenGLDebugInfo(StringBuilder out) {
        FlwDebugInfo.appendHeader(out, "OpenGL");
        FlwDebugInfo.appendLine(out, "Vendor: ").append(GlCompat.GL_VENDOR_STRING);
        FlwDebugInfo.appendLine(out, "Renderer: ").append(GlCompat.GL_RENDERER_STRING);
        FlwDebugInfo.appendLine(out, "Version: ").append(GlCompat.GL_VERSION_STRING);
        FlwDebugInfo.appendLine(out, "Shading Language Version: ").append(GlCompat.GL_SHADING_LANGUAGE_VERSION_STRING);
    }

    public static void addDebugInfo(Minecraft minecraft, List<String> systemInfo) {
        if (minecraft.m_91299_()) {
            return;
        }
        systemInfo.add("");
        systemInfo.add("Flywheel: " + FlwImplXplat.INSTANCE.getVersionStr());
        systemInfo.add("Backend: " + BackendManagerImpl.getBackendString());
        systemInfo.add("Update limiting: " + (FlwConfig.INSTANCE.limitUpdates() ? "on" : "off"));
        VisualizationManager manager = VisualizationManager.get((LevelAccessor)minecraft.f_91073_);
        if (manager != null) {
            systemInfo.add("B: " + manager.blockEntities().visualCount() + ", E: " + manager.entities().visualCount() + ", F: " + manager.effects().visualCount());
            Vec3i renderOrigin = manager.renderOrigin();
            systemInfo.add("Origin: " + renderOrigin.m_123341_() + ", " + renderOrigin.m_123342_() + ", " + renderOrigin.m_123343_());
        }
        systemInfo.add("Memory Usage: CPU: " + StringUtil.formatBytes(FlwMemoryTracker.getCpuMemory()) + ", GPU: " + StringUtil.formatBytes(FlwMemoryTracker.getGpuMemory()));
    }
}

