/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.engine_room.flywheel.api.backend.Backend;
import dev.engine_room.flywheel.lib.util.ResourceUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BackendArgument
implements ArgumentType<Backend> {
    private static final List<String> EXAMPLES = List.of("off", "flywheel:off", "instancing");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_BACKEND = new DynamicCommandExceptionType(arg -> Component.m_237110_((String)"argument.flywheel_backend.id.unknown", (Object[])new Object[]{arg}));
    public static final BackendArgument INSTANCE = new BackendArgument();
    public static final SingletonArgumentInfo<BackendArgument> INFO = SingletonArgumentInfo.m_235451_(() -> INSTANCE);

    public Backend parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceUtil.readFlywheelDefault(reader);
        Backend backend = Backend.REGISTRY.get(id);
        if (backend == null) {
            throw ERROR_UNKNOWN_BACKEND.createWithContext((ImmutableStringReader)reader, (Object)id.toString());
        }
        return backend;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String input = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (ResourceLocation id : Backend.REGISTRY.getAllIds()) {
            String idStr = id.toString();
            if (!SharedSuggestionProvider.m_82949_((String)input, (String)idStr) && !SharedSuggestionProvider.m_82949_((String)input, (String)id.m_135815_())) continue;
            builder.suggest(idStr);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

