/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.glsl;

import dev.engine_room.flywheel.backend.compile.FlwPrograms;
import dev.engine_room.flywheel.backend.glsl.LoadError;
import dev.engine_room.flywheel.backend.glsl.LoadResult;
import dev.engine_room.flywheel.backend.glsl.SourceFile;
import dev.engine_room.flywheel.lib.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.VisibleForTesting;

public class ShaderSources {
    public static final String SHADER_DIR = "flywheel/";
    @VisibleForTesting
    protected final Map<ResourceLocation, LoadResult> cache;

    public ShaderSources(ResourceManager manager) {
        SourceFinder sourceFinder = new SourceFinder(manager);
        long loadStart = System.nanoTime();
        manager.m_214159_("flywheel", ShaderSources::isShader).forEach(sourceFinder::rootLoad);
        long loadEnd = System.nanoTime();
        FlwPrograms.LOGGER.info("Loaded {} shader sources in {}", (Object)sourceFinder.results.size(), (Object)StringUtil.formatTime(loadEnd - loadStart));
        this.cache = sourceFinder.results;
    }

    private static ResourceLocation locationWithoutFlywheelPrefix(ResourceLocation loc) {
        return new ResourceLocation(loc.m_135827_(), loc.m_135815_().substring(SHADER_DIR.length()));
    }

    public LoadResult find(ResourceLocation location) {
        return this.cache.computeIfAbsent(location, loc -> new LoadResult.Failure(new LoadError.ResourceError((ResourceLocation)loc)));
    }

    public SourceFile get(ResourceLocation location) {
        return this.find(location).unwrap();
    }

    private static boolean isShader(ResourceLocation loc) {
        String path = loc.m_135815_();
        return path.endsWith(".glsl") || path.endsWith(".vert") || path.endsWith(".frag") || path.endsWith(".comp");
    }

    private static class SourceFinder {
        private final Deque<ResourceLocation> findStack = new ArrayDeque<ResourceLocation>();
        private final Map<ResourceLocation, LoadResult> results = new HashMap<ResourceLocation, LoadResult>();
        private final ResourceManager manager;

        public SourceFinder(ResourceManager manager) {
            this.manager = manager;
        }

        public void rootLoad(ResourceLocation loc, Resource resource) {
            ResourceLocation strippedLoc = ShaderSources.locationWithoutFlywheelPrefix(loc);
            if (this.results.containsKey(strippedLoc)) {
                return;
            }
            this.results.put(strippedLoc, this.readResource(strippedLoc, resource));
        }

        public LoadResult recursiveLoad(ResourceLocation location) {
            if (this.findStack.contains(location)) {
                this.findStack.addLast(location);
                List<ResourceLocation> copy = List.copyOf(this.findStack);
                this.findStack.removeLast();
                return new LoadResult.Failure(new LoadError.CircularDependency(location, copy));
            }
            this.findStack.addLast(location);
            LoadResult out = this._find(location);
            this.findStack.removeLast();
            return out;
        }

        private LoadResult _find(ResourceLocation location) {
            LoadResult out = this.results.get(location);
            if (out == null) {
                out = this.load(location);
                this.results.put(location, out);
            }
            return out;
        }

        private LoadResult load(ResourceLocation loc) {
            return this.manager.m_213713_(loc.m_246208_(ShaderSources.SHADER_DIR)).map(resource -> this.readResource(loc, (Resource)resource)).orElseGet(() -> new LoadResult.Failure(new LoadError.ResourceError(loc)));
        }

        private LoadResult readResource(ResourceLocation loc, Resource resource) {
            LoadResult loadResult;
            block8: {
                InputStream stream = resource.m_215507_();
                try {
                    String sourceString = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    loadResult = SourceFile.parse(this::recursiveLoad, loc, sourceString);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return new LoadResult.Failure(new LoadError.IOError(loc, e));
                    }
                }
                stream.close();
            }
            return loadResult;
        }
    }
}

