/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.gl;

import dev.engine_room.flywheel.backend.FlwBackend;
import dev.engine_room.flywheel.backend.compile.core.Compilation;
import dev.engine_room.flywheel.backend.gl.Driver;
import dev.engine_room.flywheel.backend.gl.shader.GlProgram;
import dev.engine_room.flywheel.backend.glsl.GlslVersion;
import dev.engine_room.flywheel.lib.math.MoreMath;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.UnknownNullability;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL40;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class GlCompat {
    public static final @UnknownNullability GLCapabilities CAPABILITIES;
    public static final String GL_VENDOR_STRING;
    public static final String GL_RENDERER_STRING;
    public static final String GL_VERSION_STRING;
    public static final String GL_SHADING_LANGUAGE_VERSION_STRING;
    public static final Driver DRIVER;
    public static final int SUBGROUP_SIZE;
    public static final boolean ALLOW_DSA = true;
    public static final GlslVersion MAX_GLSL_VERSION;
    public static final boolean SUPPORTS_DSA;
    public static final boolean SUPPORTS_INSTANCING;
    public static final boolean SUPPORTS_INDIRECT;

    private GlCompat() {
    }

    public static void init() {
    }

    public static int getComputeGroupCount(int invocations) {
        return MoreMath.ceilingDiv(invocations, SUBGROUP_SIZE);
    }

    public static void safeShaderSource(int glId, CharSequence source) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer sourceBuffer = MemoryUtil.memUTF8((CharSequence)source, (boolean)true);
            PointerBuffer pointers = stack.mallocPointer(1);
            pointers.put(sourceBuffer);
            GL20C.nglShaderSource((int)glId, (int)1, (long)pointers.address0(), (long)0L);
            MemoryUtil.memFree((Buffer)sourceBuffer);
        }
    }

    public static void safeMultiDrawElementsIndirect(GlProgram drawProgram, int mode, int type, int start, int end, long stride) {
        int count = end - start;
        long indirect = (long)start * stride;
        if (DRIVER == Driver.INTEL) {
            for (int i = 0; i < count; ++i) {
                drawProgram.setUInt("_flw_baseDraw", start + i);
                GL40.glDrawElementsIndirect((int)mode, (int)type, (long)indirect);
                indirect += stride;
            }
        } else {
            drawProgram.setUInt("_flw_baseDraw", start);
            GL43.glMultiDrawElementsIndirect((int)mode, (int)type, (long)indirect, (int)count, (int)((int)stride));
        }
    }

    private static Driver readVendorString() {
        if (CAPABILITIES == null) {
            return Driver.UNKNOWN;
        }
        if (GL_VENDOR_STRING.contains("ATI") || GL_VENDOR_STRING.contains("AMD")) {
            return Driver.AMD;
        }
        if (GL_VENDOR_STRING.contains("NVIDIA")) {
            return Driver.NVIDIA;
        }
        if (GL_VENDOR_STRING.contains("Intel")) {
            return Driver.INTEL;
        }
        if (GL_VENDOR_STRING.contains("Mesa")) {
            return Driver.MESA;
        }
        return Driver.UNKNOWN;
    }

    private static int subgroupSize() {
        if (CAPABILITIES == null) {
            return 32;
        }
        if (GlCompat.CAPABILITIES.GL_KHR_shader_subgroup) {
            return GL31C.glGetInteger((int)38194);
        }
        return DRIVER == Driver.AMD || DRIVER == Driver.MESA ? 64 : 32;
    }

    private static boolean isInstancingSupported() {
        if (CAPABILITIES == null) {
            return false;
        }
        if (GlCompat.CAPABILITIES.OpenGL33) {
            return true;
        }
        return GlCompat.CAPABILITIES.GL_ARB_shader_bit_encoding;
    }

    private static boolean isIndirectSupported() {
        if (CAPABILITIES == null) {
            return false;
        }
        if (GlCompat.CAPABILITIES.OpenGL46) {
            return true;
        }
        return GlCompat.CAPABILITIES.GL_ARB_compute_shader && GlCompat.CAPABILITIES.GL_ARB_direct_state_access && GlCompat.CAPABILITIES.GL_ARB_gpu_shader5 && GlCompat.CAPABILITIES.GL_ARB_multi_bind && GlCompat.CAPABILITIES.GL_ARB_multi_draw_indirect && GlCompat.CAPABILITIES.GL_ARB_shader_draw_parameters && GlCompat.CAPABILITIES.GL_ARB_shader_storage_buffer_object && GlCompat.CAPABILITIES.GL_ARB_shading_language_420pack && GlCompat.CAPABILITIES.GL_ARB_vertex_attrib_binding && GlCompat.CAPABILITIES.GL_ARB_shader_image_load_store && GlCompat.CAPABILITIES.GL_ARB_shader_image_size;
    }

    private static boolean isDsaSupported() {
        if (CAPABILITIES == null) {
            return false;
        }
        return GlCompat.CAPABILITIES.GL_ARB_direct_state_access;
    }

    private static GlslVersion maxGlslVersion() {
        if (CAPABILITIES == null) {
            return GlslVersion.V150;
        }
        GlslVersion[] glslVersions = GlslVersion.values();
        for (int i = glslVersions.length - 1; i > 0; --i) {
            GlslVersion version = glslVersions[i];
            if (!GlCompat.canCompileVersion(version)) continue;
            return version;
        }
        return GlslVersion.V150;
    }

    private static boolean canCompileVersion(GlslVersion version) {
        int handle = GL20.glCreateShader((int)35633);
        String source = "#version %d\nvoid main() {}\n".formatted(version.version);
        GlCompat.safeShaderSource(handle, source);
        GL20.glCompileShader((int)handle);
        boolean success = Compilation.compiledSuccessfully(handle);
        GL20.glDeleteShader((int)handle);
        return success;
    }

    private static String safeGetString(int name) {
        if (CAPABILITIES == null) {
            return "invalid";
        }
        String str = GL20C.glGetString((int)name);
        return str == null ? "null" : str;
    }

    static {
        GLCapabilities caps;
        try {
            caps = GL.getCapabilities();
        }
        catch (IllegalStateException e) {
            FlwBackend.LOGGER.warn("Failed to get GL capabilities; default Flywheel backends will be disabled.");
            caps = null;
        }
        CAPABILITIES = caps;
        GL_VENDOR_STRING = GlCompat.safeGetString(7936);
        GL_RENDERER_STRING = GlCompat.safeGetString(7937);
        GL_VERSION_STRING = GlCompat.safeGetString(7938);
        GL_SHADING_LANGUAGE_VERSION_STRING = GlCompat.safeGetString(35724);
        DRIVER = GlCompat.readVendorString();
        SUBGROUP_SIZE = GlCompat.subgroupSize();
        MAX_GLSL_VERSION = GlCompat.maxGlslVersion();
        SUPPORTS_DSA = GlCompat.isDsaSupported();
        SUPPORTS_INSTANCING = GlCompat.isInstancingSupported();
        SUPPORTS_INDIRECT = GlCompat.isIndirectSupported();
    }
}

