/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.engine.uniform;

import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.backend.engine.uniform.UniformBuffer;
import dev.engine_room.flywheel.backend.engine.uniform.UniformWriter;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class LevelUniforms
extends UniformWriter {
    private static final int SIZE = 112;
    static final UniformBuffer BUFFER = new UniformBuffer(4, 112);
    public static final Vector3f LIGHT0_DIRECTION = new Vector3f();
    public static final Vector3f LIGHT1_DIRECTION = new Vector3f();

    private LevelUniforms() {
    }

    public static void update(RenderContext context) {
        long ptr = BUFFER.ptr();
        ClientLevel level = context.level();
        float partialTick = context.partialTick();
        Vec3 skyColor = level.m_171660_(context.camera().m_90583_(), partialTick);
        Vec3 cloudColor = level.m_104808_(partialTick);
        ptr = LevelUniforms.writeVec4(ptr, (float)skyColor.f_82479_, (float)skyColor.f_82480_, (float)skyColor.f_82481_, 1.0f);
        ptr = LevelUniforms.writeVec4(ptr, (float)cloudColor.f_82479_, (float)cloudColor.f_82480_, (float)cloudColor.f_82481_, 1.0f);
        ptr = LevelUniforms.writeVec3(ptr, (Vector3fc)LIGHT0_DIRECTION);
        ptr = LevelUniforms.writeVec3(ptr, (Vector3fc)LIGHT1_DIRECTION);
        long dayTime = level.m_46468_();
        long levelDay = dayTime / 24000L;
        float timeOfDay = (float)(dayTime - levelDay * 24000L) / 24000.0f;
        ptr = LevelUniforms.writeInt(ptr, (int)(levelDay % Integer.MAX_VALUE));
        ptr = LevelUniforms.writeFloat(ptr, timeOfDay);
        ptr = LevelUniforms.writeInt(ptr, level.m_6042_().f_223549_() ? 1 : 0);
        ptr = LevelUniforms.writeFloat(ptr, level.m_46490_(partialTick));
        ptr = LevelUniforms.writeFloat(ptr, level.m_46940_());
        ptr = LevelUniforms.writeInt(ptr, level.m_46941_());
        ptr = LevelUniforms.writeInt(ptr, level.m_46471_() ? 1 : 0);
        ptr = LevelUniforms.writeFloat(ptr, level.m_46722_(partialTick));
        ptr = LevelUniforms.writeInt(ptr, level.m_46470_() ? 1 : 0);
        ptr = LevelUniforms.writeFloat(ptr, level.m_46661_(partialTick));
        ptr = LevelUniforms.writeFloat(ptr, level.m_104805_(partialTick));
        ptr = LevelUniforms.writeInt(ptr, level.m_104583_().m_108885_() ? 1 : 0);
        ResourceKey dimension = level.m_46472_();
        int dimensionId = Level.f_46428_.equals((Object)dimension) ? 0 : (Level.f_46429_.equals((Object)dimension) ? 1 : (Level.f_46430_.equals((Object)dimension) ? 2 : -1));
        ptr = LevelUniforms.writeInt(ptr, dimensionId);
        BUFFER.markDirty();
    }
}

