/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.engine.indirect;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import dev.engine_room.flywheel.backend.compile.IndirectPrograms;
import dev.engine_room.flywheel.backend.gl.GlTextureUnit;
import dev.engine_room.flywheel.backend.gl.shader.GlProgram;
import dev.engine_room.flywheel.lib.math.MoreMath;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL46;

public class DepthPyramid {
    private final IndirectPrograms programs;
    public int pyramidTextureId = -1;
    private int lastWidth = -1;
    private int lastHeight = -1;

    public DepthPyramid(IndirectPrograms programs) {
        this.programs = programs;
    }

    public void generate() {
        RenderTarget mainRenderTarget = Minecraft.m_91087_().m_91385_();
        int width = DepthPyramid.mip0Size(mainRenderTarget.f_83915_);
        int height = DepthPyramid.mip0Size(mainRenderTarget.f_83916_);
        int mipLevels = DepthPyramid.getImageMipLevels(width, height);
        this.createPyramidMips(mipLevels, width, height);
        int depthBufferId = mainRenderTarget.m_83980_();
        GL46.glMemoryBarrier((int)1024);
        GlTextureUnit.T0.makeActive();
        GlStateManager._bindTexture((int)depthBufferId);
        GlProgram downsampleFirstProgram = this.programs.getDownsampleFirstProgram();
        downsampleFirstProgram.bind();
        GL46.glBindImageTexture((int)1, (int)this.pyramidTextureId, (int)0, (boolean)false, (int)0, (int)35001, (int)33326);
        GL46.glDispatchCompute((int)MoreMath.ceilingDiv(width << 1, 64), (int)MoreMath.ceilingDiv(height << 1, 64), (int)1);
        GlProgram downsampleSecondProgram = this.programs.getDownsampleSecondProgram();
        downsampleSecondProgram.bind();
        downsampleSecondProgram.setUInt("mip_levels", mipLevels);
        int baseMipLevel = 0;
        while (baseMipLevel + 1 < mipLevels) {
            GL46.glMemoryBarrier((int)32);
            downsampleSecondProgram.setUInt("base_mip_level", baseMipLevel);
            for (int i = 0; i < Math.min(7, mipLevels - baseMipLevel); ++i) {
                GL46.glBindImageTexture((int)i, (int)this.pyramidTextureId, (int)(baseMipLevel + i), (boolean)false, (int)0, (int)35001, (int)33326);
            }
            GL46.glDispatchCompute((int)MoreMath.ceilingDiv(width >> baseMipLevel, 64), (int)MoreMath.ceilingDiv(height >> baseMipLevel, 64), (int)1);
            baseMipLevel += 6;
        }
        GL46.glMemoryBarrier((int)8);
    }

    public void bindForCull() {
        GlTextureUnit.T0.makeActive();
        GlStateManager._bindTexture((int)this.pyramidTextureId);
    }

    public void delete() {
        if (this.pyramidTextureId != -1) {
            GL32.glDeleteTextures((int)this.pyramidTextureId);
            this.pyramidTextureId = -1;
        }
    }

    private void createPyramidMips(int mipLevels, int width, int height) {
        if (this.lastWidth == width && this.lastHeight == height) {
            return;
        }
        this.lastWidth = width;
        this.lastHeight = height;
        this.delete();
        this.pyramidTextureId = GL46.glCreateTextures((int)3553);
        GL46.glTextureStorage2D((int)this.pyramidTextureId, (int)mipLevels, (int)33326, (int)width, (int)height);
        GL46.glTextureParameteri((int)this.pyramidTextureId, (int)10241, (int)9728);
        GL46.glTextureParameteri((int)this.pyramidTextureId, (int)10240, (int)9728);
        GL46.glTextureParameteri((int)this.pyramidTextureId, (int)34892, (int)0);
        GL46.glTextureParameteri((int)this.pyramidTextureId, (int)10242, (int)33071);
        GL46.glTextureParameteri((int)this.pyramidTextureId, (int)10243, (int)33071);
    }

    public static int mip0Size(int screenSize) {
        return Integer.highestOneBit(screenSize);
    }

    public static int getImageMipLevels(int width, int height) {
        int result = 1;
        while (width > 1 && height > 1) {
            ++result;
            width >>= 1;
            height >>= 1;
        }
        return result;
    }
}

