/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.engine;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.engine_room.flywheel.api.material.DepthTest;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.material.Transparency;
import dev.engine_room.flywheel.api.material.WriteMask;
import dev.engine_room.flywheel.backend.Samplers;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import org.jetbrains.annotations.Nullable;

public final class MaterialRenderState {
    public static final Comparator<Material> COMPARATOR = MaterialRenderState::compare;

    private MaterialRenderState() {
    }

    public static void setup(Material material) {
        MaterialRenderState.setupTexture(material);
        MaterialRenderState.setupBackfaceCulling(material.backfaceCulling());
        MaterialRenderState.setupPolygonOffset(material.polygonOffset());
        MaterialRenderState.setupDepthTest(material.depthTest());
        MaterialRenderState.setupTransparency(material.transparency());
        MaterialRenderState.setupWriteMask(material.writeMask());
    }

    public static void setupOit(Material material) {
        MaterialRenderState.setupTexture(material);
        MaterialRenderState.setupBackfaceCulling(material.backfaceCulling());
        MaterialRenderState.setupPolygonOffset(material.polygonOffset());
        MaterialRenderState.setupDepthTest(material.depthTest());
        WriteMask mask = material.writeMask();
        boolean writeColor = mask.color();
        RenderSystem.colorMask((boolean)writeColor, (boolean)writeColor, (boolean)writeColor, (boolean)writeColor);
    }

    private static void setupTexture(Material material) {
        Samplers.DIFFUSE.makeActive();
        AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(material.texture());
        texture.m_117960_(material.blur(), material.mipmap());
        int textureId = texture.m_117963_();
        RenderSystem.setShaderTexture((int)0, (int)textureId);
        RenderSystem.bindTexture((int)textureId);
    }

    private static void setupBackfaceCulling(boolean backfaceCulling) {
        if (backfaceCulling) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
    }

    private static void setupPolygonOffset(boolean polygonOffset) {
        if (polygonOffset) {
            RenderSystem.polygonOffset((float)-1.0f, (float)-10.0f);
            RenderSystem.enablePolygonOffset();
        } else {
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
        }
    }

    private static void setupDepthTest(DepthTest depthTest) {
        switch (depthTest) {
            case OFF: {
                RenderSystem.disableDepthTest();
                break;
            }
            case NEVER: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)512);
                break;
            }
            case LESS: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)513);
                break;
            }
            case EQUAL: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)514);
                break;
            }
            case LEQUAL: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)515);
                break;
            }
            case GREATER: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)516);
                break;
            }
            case NOTEQUAL: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)517);
                break;
            }
            case GEQUAL: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)518);
                break;
            }
            case ALWAYS: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)519);
            }
        }
    }

    private static void setupTransparency(Transparency transparency) {
        switch (transparency) {
            case OPAQUE: {
                RenderSystem.disableBlend();
                break;
            }
            case ADDITIVE: {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                break;
            }
            case LIGHTNING: {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                break;
            }
            case GLINT: {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                break;
            }
            case CRUMBLING: {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                break;
            }
            case TRANSLUCENT: {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
        }
    }

    private static void setupWriteMask(WriteMask mask) {
        RenderSystem.depthMask((boolean)mask.depth());
        boolean writeColor = mask.color();
        RenderSystem.colorMask((boolean)writeColor, (boolean)writeColor, (boolean)writeColor, (boolean)writeColor);
    }

    public static void reset() {
        MaterialRenderState.resetTexture();
        MaterialRenderState.resetBackfaceCulling();
        MaterialRenderState.resetPolygonOffset();
        MaterialRenderState.resetDepthTest();
        MaterialRenderState.resetTransparency();
        MaterialRenderState.resetWriteMask();
    }

    private static void resetTexture() {
        Samplers.DIFFUSE.makeActive();
        RenderSystem.setShaderTexture((int)0, (int)0);
    }

    private static void resetBackfaceCulling() {
        RenderSystem.enableCull();
    }

    private static void resetPolygonOffset() {
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
    }

    private static void resetDepthTest() {
        RenderSystem.disableDepthTest();
        RenderSystem.depthFunc((int)515);
    }

    private static void resetTransparency() {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private static void resetWriteMask() {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static boolean materialEquals(Material lhs, Material rhs) {
        if (lhs == rhs) {
            return true;
        }
        return lhs.blur() == rhs.blur() && lhs.mipmap() == rhs.mipmap() && lhs.backfaceCulling() == rhs.backfaceCulling() && lhs.polygonOffset() == rhs.polygonOffset() && lhs.depthTest() == rhs.depthTest() && lhs.transparency() == rhs.transparency() && lhs.writeMask() == rhs.writeMask() && lhs.light().source().equals((Object)rhs.light().source()) && lhs.texture().equals((Object)rhs.texture()) && lhs.cutout().source().equals((Object)rhs.cutout().source()) && lhs.shaders().fragmentSource().equals((Object)rhs.shaders().fragmentSource()) && lhs.shaders().vertexSource().equals((Object)rhs.shaders().vertexSource());
    }

    public static boolean materialIsAllNonNull(@Nullable Material material) {
        return material != null && material.shaders() != null && material.shaders().fragmentSource() != null && material.shaders().vertexSource() != null && material.fog() != null && material.fog().source() != null && material.cutout() != null && material.cutout().source() != null && material.light() != null && material.light().source() != null && material.texture() != null && material.depthTest() != null && material.transparency() != null && material.writeMask() != null && material.cardinalLightingMode() != null;
    }

    public static int compare(Material lhs, Material rhs) {
        if (lhs == rhs) {
            return 0;
        }
        int cmp = lhs.transparency().compareTo(rhs.transparency());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.light().source().compareTo(rhs.light().source());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.cutout().source().compareTo(rhs.cutout().source());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.shaders().fragmentSource().compareTo(rhs.shaders().fragmentSource());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.shaders().vertexSource().compareTo(rhs.shaders().vertexSource());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.texture().compareTo(rhs.texture());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Boolean.compare(lhs.blur(), rhs.blur());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Boolean.compare(lhs.mipmap(), rhs.mipmap());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Boolean.compare(lhs.backfaceCulling(), rhs.backfaceCulling());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Boolean.compare(lhs.polygonOffset(), rhs.polygonOffset());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.depthTest().compareTo(rhs.depthTest());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.writeMask().compareTo(rhs.writeMask());
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }
}

