/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.engine;

import dev.engine_room.flywheel.backend.SkyLightSectionStorageExtension;
import dev.engine_room.flywheel.backend.engine.LightStorage;
import dev.engine_room.flywheel.backend.mixin.light.LayerLightSectionStorageAccessor;
import dev.engine_room.flywheel.backend.mixin.light.LightEngineAccessor;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import java.util.BitSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public abstract class LightDataCollector {
    private static final ConstantDataLayer ALWAYS_0 = new ConstantDataLayer(0);
    private static final ConstantDataLayer ALWAYS_15 = new ConstantDataLayer(15);
    protected final LevelAccessor level;
    protected final LayerLightEventListener skyLayerListener;
    protected final LayerLightEventListener blockLayerListener;

    protected LightDataCollector(LevelAccessor level, LayerLightEventListener skyLayerListener, LayerLightEventListener blockLayerListener) {
        this.level = level;
        this.skyLayerListener = skyLayerListener;
        this.blockLayerListener = blockLayerListener;
    }

    public static LightDataCollector of(LevelAccessor level) {
        LayerLightEventListener skyLayerListener = level.m_5518_().m_75814_(LightLayer.SKY);
        LayerLightEventListener blockLayerListener = level.m_5518_().m_75814_(LightLayer.BLOCK);
        Long2ObjectFunction<DataLayer> fastSkyDataGetter = LightDataCollector.createFastSkyDataGetter(skyLayerListener);
        Long2ObjectFunction<DataLayer> fastBlockDataGetter = LightDataCollector.createFastBlockDataGetter(blockLayerListener);
        if (fastSkyDataGetter != null && fastBlockDataGetter != null) {
            return new Fast(level, skyLayerListener, blockLayerListener, fastSkyDataGetter, fastBlockDataGetter);
        }
        return new Slow(level, skyLayerListener, blockLayerListener);
    }

    @Nullable
    private static Long2ObjectFunction<DataLayer> createFastSkyDataGetter(LayerLightEventListener layerListener) {
        LightEngineAccessor accessor;
        Object s;
        if (layerListener == LayerLightEventListener.DummyLightLayerEventListener.INSTANCE) {
            return section -> ALWAYS_0;
        }
        if (layerListener instanceof LightEngineAccessor && (s = (accessor = (LightEngineAccessor)layerListener).flywheel$storage()) instanceof SkyLightSectionStorageExtension) {
            SkyLightSectionStorageExtension skyStorage = (SkyLightSectionStorageExtension)s;
            return section -> {
                DataLayer out = skyStorage.flywheel$skyDataLayer(section);
                return Objects.requireNonNullElse(out, ALWAYS_15);
            };
        }
        return null;
    }

    @Nullable
    private static Long2ObjectFunction<DataLayer> createFastBlockDataGetter(LayerLightEventListener layerListener) {
        LightEngineAccessor accessor;
        Object s;
        if (layerListener == LayerLightEventListener.DummyLightLayerEventListener.INSTANCE) {
            return section -> ALWAYS_0;
        }
        if (layerListener instanceof LightEngineAccessor && (s = (accessor = (LightEngineAccessor)layerListener).flywheel$storage()) instanceof LayerLightSectionStorageAccessor) {
            LayerLightSectionStorageAccessor storage = (LayerLightSectionStorageAccessor)s;
            return section -> {
                DataLayer out = storage.flywheel$callGetDataLayer(section, false);
                return Objects.requireNonNullElse(out, ALWAYS_0);
            };
        }
        return null;
    }

    public void collectSection(long ptr, long section) {
        this.collectSolidData(ptr, section);
        this.collectLightData(ptr, section);
    }

    private void collectSolidData(long ptr, long section) {
        long[] longArray;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        int xMin = SectionPos.m_123223_((int)SectionPos.m_123213_((long)section));
        int yMin = SectionPos.m_123223_((int)SectionPos.m_123225_((long)section));
        int zMin = SectionPos.m_123223_((int)SectionPos.m_123230_((long)section));
        BitSet bitSet = new BitSet(5832);
        int index = 0;
        for (int y = -1; y < 17; ++y) {
            for (int z = -1; z < 17; ++z) {
                for (int x = -1; x < 17; ++x) {
                    blockPos.m_122178_(xMin + x, yMin + y, zMin + z);
                    BlockState blockState = this.level.m_8055_((BlockPos)blockPos);
                    if (blockState.m_60815_() && blockState.m_60838_((BlockGetter)this.level, (BlockPos)blockPos)) {
                        bitSet.set(index);
                    }
                    ++index;
                }
            }
        }
        for (long l : longArray = bitSet.toLongArray()) {
            MemoryUtil.memPutLong((long)ptr, (long)l);
            ptr += 8L;
        }
    }

    protected abstract void collectLightData(long var1, long var3);

    protected static void write(long ptr, int x, int y, int z, int block, int sky) {
        int x1 = x + 1;
        int y1 = y + 1;
        int z1 = z + 1;
        int offset = x1 + z1 * 18 + y1 * 18 * 18;
        long packedByte = block & 0xF | (sky & 0xF) << 4;
        MemoryUtil.memPutByte((long)(ptr + (long)LightStorage.SOLID_SIZE_BYTES + (long)offset), (byte)((byte)packedByte));
    }

    private static class Fast
    extends LightDataCollector {
        private final Long2ObjectFunction<DataLayer> skyDataGetter;
        private final Long2ObjectFunction<DataLayer> blockDataGetter;

        public Fast(LevelAccessor level, LayerLightEventListener skyLayerListener, LayerLightEventListener blockLayerListener, Long2ObjectFunction<DataLayer> skyDataGetter, Long2ObjectFunction<DataLayer> blockDataGetter) {
            super(level, skyLayerListener, blockLayerListener);
            this.skyDataGetter = skyDataGetter;
            this.blockDataGetter = blockDataGetter;
        }

        @Override
        protected void collectLightData(long ptr, long section) {
            this.collectCenter(ptr, section);
            for (SectionEdge i : SectionEdge.VALUES) {
                this.collectYZPlane(ptr, SectionPos.m_123186_((long)section, (int)i.sectionOffset, (int)0, (int)0), i);
                this.collectXZPlane(ptr, SectionPos.m_123186_((long)section, (int)0, (int)i.sectionOffset, (int)0), i);
                this.collectXYPlane(ptr, SectionPos.m_123186_((long)section, (int)0, (int)0, (int)i.sectionOffset), i);
                for (SectionEdge j : SectionEdge.VALUES) {
                    this.collectXStrip(ptr, SectionPos.m_123186_((long)section, (int)0, (int)i.sectionOffset, (int)j.sectionOffset), i, j);
                    this.collectYStrip(ptr, SectionPos.m_123186_((long)section, (int)i.sectionOffset, (int)0, (int)j.sectionOffset), i, j);
                    this.collectZStrip(ptr, SectionPos.m_123186_((long)section, (int)i.sectionOffset, (int)j.sectionOffset, (int)0), i, j);
                }
            }
            this.collectCorners(ptr, section);
        }

        private void collectXStrip(long ptr, long section, SectionEdge y, SectionEdge z) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int x = 0; x < 16; ++x) {
                Fast.write(ptr, x, y.relative, z.relative, blockData.m_62560_(x, y.pos, z.pos), skyData.m_62560_(x, y.pos, z.pos));
            }
        }

        private void collectYStrip(long ptr, long section, SectionEdge x, SectionEdge z) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int y = 0; y < 16; ++y) {
                Fast.write(ptr, x.relative, y, z.relative, blockData.m_62560_(x.pos, y, z.pos), skyData.m_62560_(x.pos, y, z.pos));
            }
        }

        private void collectZStrip(long ptr, long section, SectionEdge x, SectionEdge y) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int z = 0; z < 16; ++z) {
                Fast.write(ptr, x.relative, y.relative, z, blockData.m_62560_(x.pos, y.pos, z), skyData.m_62560_(x.pos, y.pos, z));
            }
        }

        private void collectYZPlane(long ptr, long section, SectionEdge x) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    Fast.write(ptr, x.relative, y, z, blockData.m_62560_(x.pos, y, z), skyData.m_62560_(x.pos, y, z));
                }
            }
        }

        private void collectXZPlane(long ptr, long section, SectionEdge y) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    Fast.write(ptr, x, y.relative, z, blockData.m_62560_(x, y.pos, z), skyData.m_62560_(x, y.pos, z));
                }
            }
        }

        private void collectXYPlane(long ptr, long section, SectionEdge z) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    Fast.write(ptr, x, y, z.relative, blockData.m_62560_(x, y, z.pos), skyData.m_62560_(x, y, z.pos));
                }
            }
        }

        private void collectCenter(long ptr, long section) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        Fast.write(ptr, x, y, z, blockData.m_62560_(x, y, z), skyData.m_62560_(x, y, z));
                    }
                }
            }
        }

        private void collectCorners(long ptr, long section) {
            LayerLightEventListener blockLayerListener = this.blockLayerListener;
            LayerLightEventListener skyLayerListener = this.skyLayerListener;
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            int xMin = SectionPos.m_123223_((int)SectionPos.m_123213_((long)section));
            int yMin = SectionPos.m_123223_((int)SectionPos.m_123225_((long)section));
            int zMin = SectionPos.m_123223_((int)SectionPos.m_123230_((long)section));
            for (SectionEdge y : SectionEdge.VALUES) {
                for (SectionEdge z : SectionEdge.VALUES) {
                    for (SectionEdge x : SectionEdge.VALUES) {
                        blockPos.m_122178_(x.relative + xMin, y.relative + yMin, z.relative + zMin);
                        Fast.write(ptr, x.relative, y.relative, z.relative, blockLayerListener.m_7768_((BlockPos)blockPos), skyLayerListener.m_7768_((BlockPos)blockPos));
                    }
                }
            }
        }

        private static enum SectionEdge {
            LOW(15, -1, -1),
            HIGH(0, 16, 1);

            public static final SectionEdge[] VALUES;
            private final int pos;
            private final int relative;
            private final int sectionOffset;

            private SectionEdge(int pos, int relative, int sectionOffset) {
                this.pos = pos;
                this.relative = relative;
                this.sectionOffset = sectionOffset;
            }

            static {
                VALUES = SectionEdge.values();
            }
        }
    }

    private static class Slow
    extends LightDataCollector {
        public Slow(LevelAccessor level, LayerLightEventListener skyLayerListener, LayerLightEventListener blockLayerListener) {
            super(level, skyLayerListener, blockLayerListener);
        }

        @Override
        protected void collectLightData(long ptr, long section) {
            LayerLightEventListener blockLayerListener = this.blockLayerListener;
            LayerLightEventListener skyLayerListener = this.skyLayerListener;
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            int xMin = SectionPos.m_123223_((int)SectionPos.m_123213_((long)section));
            int yMin = SectionPos.m_123223_((int)SectionPos.m_123225_((long)section));
            int zMin = SectionPos.m_123223_((int)SectionPos.m_123230_((long)section));
            for (int y = -1; y < 17; ++y) {
                for (int z = -1; z < 17; ++z) {
                    for (int x = -1; x < 17; ++x) {
                        blockPos.m_122178_(xMin + x, yMin + y, zMin + z);
                        Slow.write(ptr, x, y, z, blockLayerListener.m_7768_((BlockPos)blockPos), skyLayerListener.m_7768_((BlockPos)blockPos));
                    }
                }
            }
        }
    }

    private static class ConstantDataLayer
    extends DataLayer {
        private final int value;

        private ConstantDataLayer(int value) {
            this.value = value;
        }

        public int m_62560_(int x, int y, int z) {
            return this.value;
        }
    }
}

