/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.compile.core;

import dev.engine_room.flywheel.backend.compile.core.FailedCompilation;
import dev.engine_room.flywheel.backend.compile.core.ShaderException;
import dev.engine_room.flywheel.backend.gl.shader.GlShader;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ShaderResult {
    public GlShader unwrap();

    public static ShaderResult success(GlShader program, String infoLog) {
        return new Success(program, infoLog);
    }

    public static ShaderResult failure(FailedCompilation failure) {
        return new Failure(failure);
    }

    public record Success(GlShader shader, String infoLog) implements ShaderResult
    {
        @Override
        public GlShader unwrap() {
            return this.shader;
        }
    }

    public record Failure(FailedCompilation failure) implements ShaderResult
    {
        @Override
        public GlShader unwrap() {
            throw new ShaderException.Compile(this.failure.generateMessage());
        }
    }
}

