/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.compile.core;

import dev.engine_room.flywheel.backend.compile.FlwPrograms;
import dev.engine_room.flywheel.backend.compile.core.FailedCompilation;
import dev.engine_room.flywheel.backend.compile.core.ShaderResult;
import dev.engine_room.flywheel.backend.gl.GlCompat;
import dev.engine_room.flywheel.backend.gl.shader.GlShader;
import dev.engine_room.flywheel.backend.gl.shader.ShaderType;
import dev.engine_room.flywheel.backend.glsl.GlslVersion;
import dev.engine_room.flywheel.backend.glsl.SourceComponent;
import dev.engine_room.flywheel.backend.glsl.SourceFile;
import dev.engine_room.flywheel.lib.util.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL20;

public class Compilation {
    public static final boolean DUMP_SHADER_SOURCE = System.getProperty("flw.dumpShaderSource") != null;
    private final List<SourceFile> files = new ArrayList<SourceFile>();
    private final StringBuilder generatedSource = new StringBuilder();
    private final StringBuilder fullSource = new StringBuilder();
    private int generatedLines = 0;

    public ShaderResult compile(ShaderType shaderType, String name) {
        int handle = GL20.glCreateShader((int)shaderType.glEnum);
        String source = this.fullSource.toString();
        GlCompat.safeShaderSource(handle, source);
        GL20.glCompileShader((int)handle);
        String shaderName = name + "." + shaderType.extension;
        Compilation.dumpSource(source, shaderName);
        String infoLog = GL20.glGetShaderInfoLog((int)handle);
        if (Compilation.compiledSuccessfully(handle)) {
            return ShaderResult.success(new GlShader(handle, shaderType, shaderName), infoLog);
        }
        GL20.glDeleteShader((int)handle);
        return ShaderResult.failure(new FailedCompilation(shaderName, this.files, this.generatedSource.toString(), source, infoLog));
    }

    public void version(GlslVersion version) {
        this.fullSource.append("#version ").append(version.version).append('\n');
    }

    public void enableExtension(String ext) {
        this.fullSource.append("#extension ").append(ext).append(" : enable\n");
    }

    public void requireExtension(String ext) {
        this.fullSource.append("#extension ").append(ext).append(" : require\n");
    }

    public void define(String key, String value) {
        this.fullSource.append("#define ").append(key).append(' ').append(value).append('\n');
    }

    public void define(String key) {
        this.fullSource.append("#define ").append(key).append('\n');
    }

    public void appendComponent(SourceComponent component) {
        String source = component.source();
        this.appendHeader(component, source);
        this.fullSource.append(source);
    }

    private void appendHeader(SourceComponent component, String source) {
        if (component instanceof SourceFile) {
            SourceFile file = (SourceFile)component;
            int fileId = this.files.size() + 1;
            this.files.add(file);
            this.fullSource.append("\n#line 0 ").append(fileId).append(" // ").append(file.name()).append('\n');
        } else {
            this.generatedSource.append(source).append('\n');
            this.fullSource.append("\n#line ").append(this.generatedLines).append(" 0 // (generated) ").append(component.name()).append('\n');
            this.generatedLines += StringUtil.countLines(source);
        }
    }

    private static void dumpSource(String source, String fileName) {
        if (!DUMP_SHADER_SOURCE) {
            return;
        }
        File file = new File(new File(Minecraft.m_91087_().f_91069_, "flywheel_sources"), fileName);
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file);){
            writer.write(source);
        }
        catch (Exception e) {
            FlwPrograms.LOGGER.error("Could not dump source.", (Throwable)e);
        }
    }

    public static boolean compiledSuccessfully(int handle) {
        return GL20.glGetShaderi((int)handle, (int)35713) == 1;
    }
}

