/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.compile;

import dev.engine_room.flywheel.backend.Samplers;
import dev.engine_room.flywheel.backend.compile.core.Compilation;
import dev.engine_room.flywheel.backend.gl.shader.GlProgram;
import java.util.Locale;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public enum ContextShader {
    DEFAULT(null, $ -> {}),
    CRUMBLING("_FLW_CRUMBLING", program -> program.setSamplerBinding("_flw_crumblingTex", Samplers.CRUMBLING)),
    EMBEDDED("FLW_EMBEDDED", $ -> {});

    @Nullable
    private final String define;
    private final Consumer<GlProgram> onLink;

    private ContextShader(String define, Consumer<GlProgram> onLink) {
        this.define = define;
        this.onLink = onLink;
    }

    public void onLink(GlProgram program) {
        this.onLink.accept(program);
    }

    public void onCompile(Compilation comp) {
        if (this.define != null) {
            comp.define(this.define);
        }
    }

    public String nameLowerCase() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

