/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend;

import dev.engine_room.flywheel.api.layout.ArrayElementType;
import dev.engine_room.flywheel.api.layout.ElementType;
import dev.engine_room.flywheel.api.layout.FloatRepr;
import dev.engine_room.flywheel.api.layout.IntegerRepr;
import dev.engine_room.flywheel.api.layout.Layout;
import dev.engine_room.flywheel.api.layout.MatrixElementType;
import dev.engine_room.flywheel.api.layout.ScalarElementType;
import dev.engine_room.flywheel.api.layout.UnsignedIntegerRepr;
import dev.engine_room.flywheel.api.layout.ValueRepr;
import dev.engine_room.flywheel.api.layout.VectorElementType;
import dev.engine_room.flywheel.backend.gl.GlNumericType;
import dev.engine_room.flywheel.backend.gl.array.VertexAttribute;
import java.util.ArrayList;
import java.util.List;

public class LayoutAttributes {
    public static List<VertexAttribute> attributes(Layout layout) {
        ArrayList<VertexAttribute> out = new ArrayList<VertexAttribute>();
        for (Layout.Element element : layout.elements()) {
            LayoutAttributes.element(out, element.type());
        }
        return out;
    }

    private static void element(List<VertexAttribute> out, ElementType type) {
        if (type instanceof ScalarElementType) {
            ScalarElementType scalar = (ScalarElementType)type;
            LayoutAttributes.vector(out, scalar.repr(), 1);
        } else if (type instanceof VectorElementType) {
            VectorElementType vector = (VectorElementType)type;
            LayoutAttributes.vector(out, vector.repr(), vector.size());
        } else if (type instanceof MatrixElementType) {
            MatrixElementType matrix = (MatrixElementType)type;
            LayoutAttributes.matrix(out, matrix);
        } else if (type instanceof ArrayElementType) {
            ArrayElementType array = (ArrayElementType)type;
            LayoutAttributes.array(out, array);
        } else {
            throw new IllegalArgumentException("Unknown type " + type);
        }
    }

    private static void vector(List<VertexAttribute> out, ValueRepr repr, int size) {
        if (repr instanceof IntegerRepr) {
            IntegerRepr integer = (IntegerRepr)repr;
            out.add(new VertexAttribute.Int(LayoutAttributes.toGlType(integer), size));
        } else if (repr instanceof UnsignedIntegerRepr) {
            UnsignedIntegerRepr integer = (UnsignedIntegerRepr)repr;
            out.add(new VertexAttribute.Int(LayoutAttributes.toGlType(integer), size));
        } else if (repr instanceof FloatRepr) {
            FloatRepr floatRepr = (FloatRepr)repr;
            out.add(new VertexAttribute.Float(LayoutAttributes.toGlType(floatRepr), size, LayoutAttributes.isNormalized(floatRepr)));
        } else {
            throw new IllegalArgumentException("Unknown repr " + repr);
        }
    }

    private static void matrix(List<VertexAttribute> out, MatrixElementType matrix) {
        int size = matrix.columns();
        FloatRepr repr = matrix.repr();
        GlNumericType glType = LayoutAttributes.toGlType(repr);
        boolean normalized = LayoutAttributes.isNormalized(repr);
        for (int i = 0; i < matrix.rows(); ++i) {
            out.add(new VertexAttribute.Float(glType, size, normalized));
        }
    }

    private static void array(List<VertexAttribute> out, ArrayElementType array) {
        ElementType innerType = array.innerType();
        int length = array.length();
        for (int i = 0; i < length; ++i) {
            LayoutAttributes.element(out, innerType);
        }
    }

    private static GlNumericType toGlType(IntegerRepr repr) {
        return switch (repr) {
            default -> throw new IncompatibleClassChangeError();
            case IntegerRepr.BYTE -> GlNumericType.BYTE;
            case IntegerRepr.SHORT -> GlNumericType.SHORT;
            case IntegerRepr.INT -> GlNumericType.INT;
        };
    }

    private static GlNumericType toGlType(UnsignedIntegerRepr repr) {
        return switch (repr) {
            default -> throw new IncompatibleClassChangeError();
            case UnsignedIntegerRepr.UNSIGNED_BYTE -> GlNumericType.UBYTE;
            case UnsignedIntegerRepr.UNSIGNED_SHORT -> GlNumericType.USHORT;
            case UnsignedIntegerRepr.UNSIGNED_INT -> GlNumericType.UINT;
        };
    }

    private static GlNumericType toGlType(FloatRepr repr) {
        return switch (repr) {
            default -> throw new IncompatibleClassChangeError();
            case FloatRepr.BYTE, FloatRepr.NORMALIZED_BYTE -> GlNumericType.BYTE;
            case FloatRepr.UNSIGNED_BYTE, FloatRepr.NORMALIZED_UNSIGNED_BYTE -> GlNumericType.UBYTE;
            case FloatRepr.SHORT, FloatRepr.NORMALIZED_SHORT -> GlNumericType.SHORT;
            case FloatRepr.UNSIGNED_SHORT, FloatRepr.NORMALIZED_UNSIGNED_SHORT -> GlNumericType.USHORT;
            case FloatRepr.INT, FloatRepr.NORMALIZED_INT -> GlNumericType.INT;
            case FloatRepr.UNSIGNED_INT, FloatRepr.NORMALIZED_UNSIGNED_INT -> GlNumericType.UINT;
            case FloatRepr.FLOAT -> GlNumericType.FLOAT;
        };
    }

    private static boolean isNormalized(FloatRepr repr) {
        return switch (repr) {
            case FloatRepr.NORMALIZED_BYTE, FloatRepr.NORMALIZED_UNSIGNED_BYTE, FloatRepr.NORMALIZED_SHORT, FloatRepr.NORMALIZED_UNSIGNED_SHORT, FloatRepr.NORMALIZED_INT, FloatRepr.NORMALIZED_UNSIGNED_INT -> true;
            default -> false;
        };
    }
}

