/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.api.material;

import dev.engine_room.flywheel.api.material.CardinalLightingMode;
import dev.engine_room.flywheel.api.material.CutoutShader;
import dev.engine_room.flywheel.api.material.DepthTest;
import dev.engine_room.flywheel.api.material.FogShader;
import dev.engine_room.flywheel.api.material.LightShader;
import dev.engine_room.flywheel.api.material.MaterialShaders;
import dev.engine_room.flywheel.api.material.Transparency;
import dev.engine_room.flywheel.api.material.WriteMask;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface Material {
    public MaterialShaders shaders();

    public FogShader fog();

    public CutoutShader cutout();

    public LightShader light();

    public ResourceLocation texture();

    public boolean blur();

    public boolean mipmap();

    public boolean backfaceCulling();

    public boolean polygonOffset();

    public DepthTest depthTest();

    public Transparency transparency();

    public WriteMask writeMask();

    public boolean useOverlay();

    public boolean useLight();

    public CardinalLightingMode cardinalLightingMode();

    default public boolean ambientOcclusion() {
        return true;
    }

    default public boolean equals(@Nullable Material other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.blur() == other.blur() && this.mipmap() == other.mipmap() && this.backfaceCulling() == other.backfaceCulling() && this.polygonOffset() == other.polygonOffset() && this.depthTest() == other.depthTest() && this.transparency() == other.transparency() && this.writeMask() == other.writeMask() && this.useOverlay() == other.useOverlay() && this.useLight() == other.useLight() && this.cardinalLightingMode() == other.cardinalLightingMode() && this.ambientOcclusion() == other.ambientOcclusion() && this.shaders().fragmentSource().equals((Object)other.shaders().fragmentSource()) && this.shaders().vertexSource().equals((Object)other.shaders().vertexSource()) && this.fog().source().equals((Object)other.fog().source()) && this.cutout().source().equals((Object)other.cutout().source()) && this.light().source().equals((Object)other.light().source()) && this.texture().equals((Object)other.texture());
    }
}

